﻿<%@ Register TagPrefix="fme" Namespace="WebControlCaptcha" Assembly="WebControlCaptcha" %>
<%@ Import Namespace="System.Net.Mail" %>
<%@ Page AutoEventWireup="true" EnableSessionState="False" %>

<script runat="server">
  Protected Sub btnSend_Click(ByVal sender As Object, ByVal e As System.EventArgs)
    If Page.IsValid Then
      Dim objMailMessage As MailMessage
      Dim strBody As String

      strBody = "Name:          " & txtName.Text & vbNewLine
      strBody &= "Email:         " & txtEmail.Text & vbNewLine
      strBody &= "Comments:      " & txtComments.Text & vbNewLine & vbNewLine
		
      strBody &= "Likes:         " & txtLike.Text & vbNewLine
      strBody &= "Improve:       " & txtImproved.Text & vbNewLine & vbNewLine
		
      strBody &= "Job title:     " & txtJob.Text & vbNewLine
      strBody &= "Organisation:  " & dropType.SelectedValue & vbNewLine
      strBody &= "Country:       " & txtCountry.Text & vbNewLine
      strBody &= "Keep informed: " & dropInformed.SelectedValue

      objMailMessage = New MailMessage
			objMailMessage.From = New MailAddress("web@fme-online.org", "FME Website")
			objMailMessage.To.Add("tim@timfoster.org")
			objMailMessage.To.Add("john.cammack@ukonline.co.uk")
			objMailMessage.Bcc.Add("fme@fruitysolutions.com")
      objMailMessage.Subject = "Message from " & txtName.Text
      objMailMessage.Body = strBody

			Dim mySmtp As New SmtpClient("localhost", 26)
			mySmtp.Send(objMailMessage)
      
      Response.Redirect("contactusprocess.aspx")
    Else
      litMessage.Text = "The letters you entered were incorrect &ndash; please try again. We had to implement this security measure as we were receiving a lot of spam, and apologise for the inconvenience."
      litTitle.Text = "Sorry, the letters you entered were incorrect"
    End If
  End Sub
</script>


<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">


<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>FME - Contact us</title>	<link rel="stylesheet" type="text/css" href="css/default.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="css/print.css" media="print" />
</head>

<body>
<div id="container">
	<div id="header">

<div id="logo">
	<a href="index.html"><img src="images/logo.gif" alt="Financial Management for Emergencies" width="175" height="93" /></a>
</div>
<div id="interface">
	<div id="buttons">
		<ul>
			<li id="buttons_glossary"><a href="glossary.html">Glossary</a></li>

			<li id="buttons_print"><a href="javascript:print();">Print</a></li>
			<li id="buttons_search"><a href="http://www.fme-online.org/search.html">Search</a></li>
		</ul>
	</div>				
	<div id="tabs">
		<ul>
			
				<li id="tabs_1">
					<a href="budget/overview.html" class="">Budget</a>
				</li>
			
				<li id="tabs_2">
					<a href="donors/overview.html" class="">Donors</a>
				</li>
			
				<li id="tabs_3">
					<a href="cash/overview.html" class="">Cash</a>
				</li>
			
				<li id="tabs_4">
					<a href="staffing/overview.html" class="">Staffing</a>
				</li>
			
				<li id="tabs_5">
					<a href="systems/overview.html" class="">Systems</a>
				</li>
			
				<li id="tabs_6">
					<a href="controls/overview.html" class="">Controls</a>

				</li>
			
		</ul>
	</div>
</div>
</div>
	<div id="spread">
		<h1><asp:Literal ID="litTitle" runat="server">Contact us</asp:Literal></h1>
		<form id="form1" runat="server">
		<p><asp:Literal ID="litMessage" runat="server">We welcome your feedback to help us to improve future editions of this guide.  
</asp:Literal></p>
		<p>
		  <asp:Literal runat="server">Please note that you will need to be connected to the internet to submit the form below.</asp:Literal>
		  </p>
		<table border="0" cellpadding="4">
		<tr>
			<td class="label" style="width: 300px">Name:</td>
			<td><asp:TextBox ID="txtName" Width="300px" runat="server" /></td>
		</tr>
		<tr>
			<td class="label" style="width: 300px">Email:</td>
			<td><asp:TextBox ID="txtEmail" Width="300px" runat="server" /></td>
		</tr>
		<tr>
			<td class="label" style="width: 300px">Comments or questions:</td>
			<td><asp:TextBox ID="txtComments" Width="300px" Height="80px" TextMode="MultiLine" runat="server" /></td>
		</tr>
		<tr>
			<td class="label" style="width: 300px">What do you like about FME?</td>
			<td><asp:TextBox ID="txtLike" Width="300px" Height="40px" TextMode="MultiLine" runat="server" /></td>
		</tr>
		<tr>
			<td class="label" style="width: 300px; height: 56px;">What could be improved?</td>
			<td style="height: 56px"><asp:TextBox ID="txtImproved" Width="300px" Height="80px" TextMode="MultiLine" runat="server" /></textarea></td>
		</tr>

		<tr>
			<td class="label" style="width: 300px">What is your job title?</td>
			<td>
				<asp:TextBox ID="txtJob" Width="300px" runat="server" />
			</td>
		</tr>
		<tr>
			<td class="label" style="width: 300px">What type of organisation do you work for?</td>
			<td>
			  <asp:DropDownList ID="dropType" width="304px" runat="server">
			    <asp:ListItem Value="International NGO" Text="International NGO" />
			    <asp:ListItem Value="National NGO" Text="National NGO" />
			    <asp:ListItem Value="United Nations" Text="United Nations" />
			    <asp:ListItem Value="Commercial" Text="Commercial" />
			    <asp:ListItem Value="Military" Text="Military" />
			    <asp:ListItem Value="Government" Text="Government" />
			    <asp:ListItem Value="Unemployed" Text="Unemployed" />
			    <asp:ListItem Value="Student" Text="Student" />
			    <asp:ListItem Value="Other" Text="Other" />
			  </asp:DropDownList>
			</td>
		</tr>
		<tr>
			<td class="label" style="width: 300px">Which country do you live in?</td>
			<td>
				<asp:TextBox ID="txtCountry" Width="300px" runat="server" />
			</td>
		</tr>
		<tr>
			<td class="label" style="width: 300px">Do you want to be informed of developments?</td>
			<td>
				<asp:DropDownList ID="dropInformed" runat="server">
				  <asp:ListItem Value="No" Text="No" Selected="True" />
				  <asp:ListItem Value="Yes" Text="Yes" />
				</asp:DropDownList>
			</td>
		</tr>
    <tr>
      <td class="label">
        Please enter the following letters:<br />
        <span style="color: #888888; font-weight: normal;">(this helps us prevent spam)</span>
      </td>
      <td>
        <fme:captchacontrol id="fmeCaptcha" runat="server" Text="&nbsp;" />
      </td>
    </tr>
		<tr>
			<td class="label" style="width: 299px"></td>
			<td>
				<asp:Button ID="btnSend" runat="server" Height="28" Width="100" Text="Send" OnClick="btnSend_Click" />
				
			</td>
		</tr>
		</table>
		</form>
    <br />
	</div>
	<div id="clear" />
	
<div id="footer"><div id="copyright">
	&copy; 2005 
</div>
<div id="links">
	<a href="disclaimer.html">Disclaimer</a>
	&nbsp;|&nbsp;

	<a href="copyright.html">Copyright</a> 
	&nbsp;|&nbsp;
	<a href="aboutfme.html">About FME</a>
	&nbsp;|&nbsp;
	<a href="keycontacts.html">Key contacts</a>	
	&nbsp;|&nbsp;
	<a href="furtherreading.html">Further reading</a>

	&nbsp;|&nbsp;
	<a href="http://www.fme-online.org/contactus.aspx">Contact us</a>		
</div>

</div>
</div>
</body>



</html>
